/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.model.AnalogNetworkNodeParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.panel.NetworkNodePanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AnalogNetworkNodePanel
extends NetworkNodePanel {
    private static final String ANALOG_INPUT = Language.getString("block.AnalogInput");
    private static final String ANALOG_OUTPUT = Language.getString("block.AnalogOutput");
    private static final String ANALOG_MARKER = Language.getString("block.AnalogMarker");

    public AnalogNetworkNodePanel() {
    }

    public AnalogNetworkNodePanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
    }

    protected void initialize() {
        this.setLayout(new BorderLayout(5, 5));
        this.fParameterPanelLayout = new CardLayout();
        this.fParameterPanel = new JPanel(this.fParameterPanelLayout);
        this.fParameterPanel.add((Component)this.getBlockPanel(), "Block");
        this.fParameterPanel.add((Component)this.getVMPanel(), "VM");
        this.add((Component)this.getParameterTypePanel(), "North");
        this.add((Component)this.fParameterPanel, "Center");
    }

    protected BorderJPanel getParameterTypePanel() {
        if (this.fParameterTypePanel == null) {
            this.fParameterTypePanel = new BorderJPanel(new GridLayout(3, 1));
            this.fParameterTypePanel.setTitle(Language.getString("panel.networkNodePanel.readValueForm", "Read value from"));
            ButtonGroup connectionGroup = new ButtonGroup();
            this.fVMButton = new JRadioButton(Language.getString("block.NetworkNode.vm", "VM"));
            this.fSlaveButton = new JRadioButton(Language.getString("panel.networkNodePanel.slaveSelection", "Slave"));
            this.fVMButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        AnalogNetworkNodePanel.this.fParameterPanelLayout.show(AnalogNetworkNodePanel.this.fParameterPanel, "VM");
                    }
                }
            });
            this.fSlaveButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        AnalogNetworkNodePanel.this.fParameterPanelLayout.show(AnalogNetworkNodePanel.this.fParameterPanel, "Block");
                    }
                }
            });
            connectionGroup.add(this.fVMButton);
            connectionGroup.add(this.fSlaveButton);
            this.fParameterTypePanel.add(this.fVMButton);
            this.fParameterTypePanel.add(this.fSlaveButton);
        }
        return this.fParameterTypePanel;
    }

    protected JComboBox getContantsCombobox() {
        if (this.fContantsList == null) {
            String[] blockType = new String[]{ANALOG_INPUT, ANALOG_OUTPUT};
            this.fContantsList = new JComboBox<String>(blockType);
            this.fContantsList.setSelectedItem(null);
            this.fContantsList.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        int blockNumber = -1;
                        String blockName = "";
                        String selectedItem = e.getItem().toString();
                        if (selectedItem.equalsIgnoreCase(ANALOG_INPUT)) {
                            blockName = "AI";
                            blockNumber = 11;
                        } else if (selectedItem.equalsIgnoreCase(ANALOG_OUTPUT)) {
                            blockName = "AQ";
                            blockNumber = 13;
                        } else {
                            AnalogNetworkNodePanel.this.fBlockList.setModel(new DefaultComboBoxModel());
                        }
                        if (blockNumber != -1) {
                            Block block = ((AnalogNetworkNodeParameter)AnalogNetworkNodePanel.this.fParameterReference).getBlock();
                            int maxResource = block.getHardware().getMaxResource(blockNumber);
                            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
                            for (int i = 1; i <= maxResource; ++i) {
                                model.addElement(blockName + i);
                            }
                            AnalogNetworkNodePanel.this.fBlockList.setModel(model);
                        }
                    }
                }
            });
        }
        return this.fContantsList;
    }

    protected JPanel getVMPanel() {
        if (this.fVMPanel == null) {
            this.fVMPanel = new JPanel(new GridBagLayout());
            JLabel vmAddress = new JLabel(Language.getString("block.NetworkNode.vw", "VW address:"));
            this.fVBSpinner = new EditableNumericSpinner();
            this.fVBSpinner.setMinMax(0, this.getVMSize() - 2);
            this.fBitSpinner = new EditableNumericSpinner();
            this.fBitSpinner.setMinMax(0, 7);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.anchor = 18;
            constraints.insets = new Insets(10, 10, 5, 5);
            constraints.gridx = 0;
            constraints.gridy = 0;
            this.fVMPanel.add((Component)vmAddress, constraints);
            constraints.insets = new Insets(5, 0, 5, 10);
            constraints.gridx = 1;
            constraints.gridy = 0;
            this.fVMPanel.add((Component)this.fVBSpinner, constraints);
            constraints.gridx = 2;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            this.fVMPanel.add((Component)new JPanel(), constraints);
            constraints.gridx = 3;
            constraints.gridy = 1;
            constraints.weighty = 1.0;
            this.fVMPanel.add((Component)new JPanel(), constraints);
        }
        return this.fVMPanel;
    }

    public String getHelpIdString() {
        return "block.AnalogNetworkNode";
    }

    protected String getBlockAbbreviation(int opcode) {
        if (11 == opcode) {
            return "AI";
        }
        if (13 == opcode) {
            return "AQ";
        }
        if (16 == opcode) {
            return "AM";
        }
        return "";
    }

    protected String getConfiguredBlockName(int numberType) {
        if (11 == numberType) {
            return ANALOG_INPUT;
        }
        if (13 == numberType) {
            return ANALOG_OUTPUT;
        }
        if (16 == numberType) {
            return ANALOG_MARKER;
        }
        return "";
    }

    protected int getBlockTypeNumber(String typeName) {
        if (ANALOG_INPUT == typeName) {
            return 11;
        }
        if (ANALOG_OUTPUT == typeName) {
            return 13;
        }
        if (ANALOG_MARKER == typeName) {
            return 16;
        }
        return 0;
    }
}

